#include <iostream>
#include <fstream>
#include <cstdio>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

typedef long long ll;

int n, m;
vector<vector<int>> from;
vector<int> max_path_from_0;
vector<int> used;
vector<bool> can_reach_0;
vector<int> p;

void dfs(int ind, int already) {
    used[ind] = 1;
    for (auto i : from[ind]) {
        if (used[i] == 2) {
            if (max_path_from_0[i] < already + 1)
                p[i] = ind;
            max_path_from_0[i] = max(max_path_from_0[i], already + 1);
        }
        else if (used[i] == 0) {
            if (max_path_from_0[i] < already + 1)
                p[i] = ind;
            max_path_from_0[i] = max(max_path_from_0[i], already + 1);
            dfs(i, max_path_from_0[i]);
        }
    }
    used[ind] = 2;
}

vector<int> w;
void write(int ind) {
    if (ind != -1) {
        w.push_back(ind);
        write(p[ind]);
    }
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    //freopen("inC.txt", "r", stdin);

    cin >> n >> m;
    from.resize(n);
    can_reach_0.resize(n);
    for (int i = 0; i < m; i++) {
        int v, u;
        cin >> v >> u; v--; u--;
        from[v].push_back(u);

        if (u == 0)
            can_reach_0[v] = true;
    }

    max_path_from_0.resize(n);
    used.resize(n);
    p.resize(n); p[0] = -1;
    dfs(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs(0, 1);
    fill(used.begin(), used.end(), 0);
    dfs(0, 1);

    for (int i = 0; i < n; i++) {
        //cout << i+1 << ' ' << max_path_from_0[i] << endl;
        if (max_path_from_0[i] == n && can_reach_0[i]) {
            cout << "YES\n";
            write(i);
            for (int i = 0; i < n; i++)
                cout << w[n-i-1] + 1 << ' ';
            cout << 1;
            return 0;
        }
    }
    cout << "NO";

    return 0;
}